import matplotlib
# 使用 TkAgg 后端
matplotlib.use("TkAgg")

import numpy as np
import matplotlib.pyplot as plt
from mpl_toolkits.mplot3d import Axes3D  # noqa: F401
from matplotlib.widgets import Slider

def main():
    # === 1. 读入在 notebook 里保存的数组 ===
    X = np.load("X.npy")
    Y = np.load("Y.npy")
    Z_rec = np.load("Z_rec.npy")

    # === 2. 创建图窗和 3D 坐标轴 ===
    fig = plt.figure(figsize=(8, 7))
    ax = fig.add_subplot(111, projection="3d")

    # 初始视角
    init_elev = 30
    init_azim = 45

    surf = ax.plot_surface(
        X, Y, Z_rec,
        cmap="viridis",
        linewidth=0, antialiased=True
    )

    ax.view_init(elev=init_elev, azim=init_azim)
    ax.set_title("3D Surface Viewer (TkAgg, with Sliders)")
    ax.set_xlabel("X")
    ax.set_ylabel("Y")
    ax.set_zlabel("Z")

    # === 3. 在图窗下方预留区域放滑块 ===
    # [left, bottom, width, height]，都是 0~1 的相对坐标
    fig.subplots_adjust(left=0.1, right=0.95, bottom=0.20)

    ax_elev = fig.add_axes([0.15, 0.08, 0.70, 0.03])
    ax_azim = fig.add_axes([0.15, 0.03, 0.70, 0.03])

    s_elev = Slider(
        ax=ax_elev,
        label="Elevation",
        valmin=0,
        valmax=90,
        valinit=init_elev
    )

    s_azim = Slider(
        ax=ax_azim,
        label="Azimuth",
        valmin=0,
        valmax=180,
        valinit=init_azim
    )

    # === 4. 定义当滑块变化时的回调函数 ===
    def update(val):
        elev = s_elev.val
        azim = s_azim.val
        ax.view_init(elev=elev, azim=azim)
        fig.canvas.draw_idle()

    s_elev.on_changed(update)
    s_azim.on_changed(update)

    # === 5. 显示窗口 ===
    plt.show()


if __name__ == "__main__":
    main()
